program ltos;
{PURPOSE:
   LongToShort is a command line utility that lets you use 
   long filenames with older applications that don't support
   them. If command line arguments are added after the long
   filename, the long filename must be in quotes.
SYNTAX:
   LTOS program.exe This is a long filename.ext
   LTOS program.exe "This is a long filename.ext" arg1 arg2...
COPYRIGHT INFORMATION:
   LongToShort 1.0 Copyright (c) 1997
   Ziff-Davis Publishing Company.
   All rights reserved.
   First Published in PC Magazine, US Edition, April 8, 1997.
   Author: Neil J. Rubenking
}

uses Windows, SysUtils;

VAR
  CommandString, WorkDir,
  ShortName, LongName,
  MoreArgs               : String;
  P, PWorkDir, PParams   : PChar;
  Len, QPos              : Integer;
  TPI                    : TProcessInformation;
  TSI                    : TStartupInfo;
begin
  IF ParamCount > 1 THEN
    BEGIN
      {set CommandString to first parameter}
      CommandString := ParamStr(1);
      {set PParams to point to command line parameters}
      PParams := StrPos(CmdLine, PChar(ParamStr(1)));
      {set P to point to parameters starting with 2nd}
      P := StrPos(PParams+Length(ParamStr(1)), PChar(ParamStr(2)));
      {set LongName to remainder of command line (from 2nd param)}
      LongName := StrPas(P);
      QPos := Pos('"', LongName);
      {if LongName was in quotes, get remaining arguments}
      IF ((P-1)[0]='"') AND (QPos<>0) THEN
        BEGIN
          MoreArgs := Copy(LongName, QPos+2,Length(LongName)-QPos-1);
          LongName := Copy(LongName, 1, QPos-1);
        END
      ELSE MoreArgs := '';
      Len := Length(LongName);
      GetMem(P, Len);
      {get a short pathname using Windows API function}
      IF GetShortPathName(PChar(LongName), P, Len) = 0 THEN
        BEGIN
          MessageBox(0, PChar(Format('Cannot get short name for "%s'+
            '"'#13'%s', [LongName, SysErrorMessage(GetLastError)])),
            'LTOS', MB_OK OR MB_ICONSTOP);
          Halt;
        END;
      ShortName := StrPas(P);
      FreeMem(P);
      {get the working directory}
      WorkDir := ExtractFileDir(ShortName);
      IF WorkDir='' THEN PWorkDir := NIL
      ELSE PWorkDir := PChar(WorkDir);
      {build a command string}
      CommandString := CommandString + ' ' + ShortName;
      IF MoreArgs <> '' THEN
        CommandString := CommandString + ' ' + MoreArgs;
      {create the process}
      FillChar(TSI, SizeOf(TSI), 0);
      TSI.CB := SizeOf(TSI);
      IF CreateProcess(NIL, PChar(CommandString), NIL, NIL, False,
          DETACHED_PROCESS OR NORMAL_PRIORITY_CLASS, NIL,
          PWorkDir, TSI, TPI) THEN
        BEGIN
          CloseHandle(TPI.hThread);
          CloseHandle(TPI.hProcess);
        END
      ELSE
        MessageBox(0, PChar(Format('Failed to execute "%s"'#13'%s',
          [PParams, SysErrorMessage(GetLastError)])), 'LTOS',
          MB_OK OR MB_ICONSTOP);
    END
  ELSE
    MessageBox(0, 'LTOS requires at least two parameters, a program'+
      ' name and a long filename. If more parameters follow the '+
      'long filename, you must enclose the long filename in quotes.',
      'LTOS', MB_OK OR MB_ICONSTOP);
end.
{Total lines excluding blanks and comments - 61.
 15 lines are devoted to error and syntax reporting, so total
 essential lines is 46}

